*
* ROUTINE TO FIND WHERE THE UTHERNET II CARD IS
* THIS WILL SKIP CARDS THAT HAVE FIRMWARE.
* BY BENOIT GILON - 2016
*
AUXPTR EQU $06
SLOT EQU $FE
SLOT16 EQU $FF
YMODR EQU $85 ; OFFSET TO WIZCHIP MODE REGISTER
COUT1 EQU $FDF0

 ORG $300

 JSR CHKSLTS
 BCS :0
 LDA #MESSOK
 LDY #>MESSOK
 JSR PRINT
 LDA SLOT
 ORA #$B0
 JSR COUT1
 LDA #$8D
 JMP COUT1
:0 LDA #MESSNOK
 LDY #>MESSNOK
*
*
PRINT STA AUXPTR
 STY AUXPTR+1
 LDY #0
]LOOP LDA (AUXPTR),Y
 BEQ :0
 JSR COUT1
 INY
 BNE ]LOOP ; ALWAYS
:0 RTS
*
*
MESSOK HEX 8D
 ASC "FOUND UTHERNET II IN SLOT #",00
MESSNOK HEX 8D
 ASC "NO UTHERNET II DETECTED",8D,00
*
*
CHKSLTS LDA #0
 STA AUXPTR
 LDA #$C7
 STA AUXPTR+1
 AND #7
 STA SLOT
]LOOP1 LDX #MVAL-MOFFST-1
]LOOP LDY MOFFST,X
 LDA (AUXPTR),Y
 CMP MVAL,X
 BNE :1
 DEX
 BPL ]LOOP
]NEXT DEC AUXPTR+1
 DEC SLOT
 BPL ]LOOP1
 SEC
 RTS
*
* NO FIRMWARE CARD FOUND IN THIS SLOT: GOOD!
* IS IT A DISK II CONTROLLER CARD?
*
:1 LDA #0
 TAX
 TAY
]LOOP ADC (AUXPTR),Y
 BCC *+3
 INX
 INY
 BNE ]LOOP
 CMP #$C2 ; 7BC2 IS CHKSUM FOR DISK II
 BNE *+6
 CPX #$7B
 BEQ ]NEXT
 LDA AUXPTR+1
 ASL
 ASL
 ASL
 ASL
 STA SLOT16
 ORA #YMODR
 TAY
 LDA #$80
 STA $BFFF,Y
 LDA #3
 STA $BFFF,Y
 CMP $BFFF,Y
 BNE ]NEXT
 CLC
 RTS
*
MOFFST HEX 05070B ; LOCATIONS OF FIRMWARE ID BYTES
MVAL HEX 381801 ; VALUES OF FIRMWARE ID BYTES
